unit IsAdvStringGrid;

// Reference
// http://docwiki.embarcadero.com/RADStudio/en/Creating_a_FireMonkey_Component
interface

uses
  System.SysUtils, System.Classes, FMX.Types, FMX.Controls, System.UITypes,
  FMX.Layouts, FMX.Grid, IsArrayLib;

type

  TFindParameters = (fnMatchCase, fnMatchFull, fnMatchRegular,
    fnDirectionLeftRight, fnMatchStart, fnFindInCurrentRow, fnFindInCurrentCol,
    fnIncludeFixed, fnAutoGoto, fnIgnoreHTMLTags, fnBackward);
  {
    fnMatchCase		match case
    fnMatchFull		match full word only
    fnMatchRegular		match the expresion
    fnDirectionLeftRight	search from left to right instead of from top to bottom first
    fnMatchStart		match from first letter of cell content only
    fnFindInCurrentRow	search in current row only
    fnFindInCurrentCol	search in current column only
    fnIncludeFixed		search fixed rows and columns too
    fnAutoGoto		go to cell when found
    fnIgnoreHTMLTags	ignore HTML tags in search
    fnBackward		search in inverse direction, ie right to left or bottom to top
  }
  TFindParams = Set of TFindParameters;

  TGridCell = Record
    Row, Col: integer;
  end;

  TGridRect = Record
    case Boolean of
      True:
        (Top, Left, Bottom, Right: integer);
      False:
        (First, Last: TGridCell);
  end;

  TISAdvStringGrid = class(TStringGrid)
  private
    { Private declarations }
    FOneDObjectArray: TArrayofObjects;
    FTwoDObjectArray: TTwoDArrayofObjects;
    FFixedCols:Integer;
    Function CellMatches(AMatchText: String; ARow, ACol: integer;
      AMatchStates: TFindParams): Boolean;
    procedure SetOneDObjectArray(const Value: TArrayofObjects);
    procedure SetTwoDObjectArray(const Value: TTwoDArrayofObjects);
    function GetColumnCount: integer;
    procedure SetColumnCount(const Value: integer);
  protected
    { Protected declarations }
    //function GetStyleObject: TControl; override;
  public
    { Public declarations }
    function FindFirst(ASearchText: String; AMatchStates: TFindParams)
      : TGridCell;
    function Find(AStart: TGridCell ;ASearchText: String; AMatchStates: TFindParams)
      : TGridCell;
    Function ObjectSelected:TObject;
    Procedure ClearAll;
    Procedure AutoSizeColumns(ADoFixed: Boolean; APadding: Real);
    Procedure AutoSizeRows(ADoFixed: Boolean; APadding: Real);
    Procedure AutoSizeCells(ADoFixed: Boolean; AVPadding: Real;  AHPadding: Real);
    Procedure SelectRows(AFirstRow:Integer; ANumberToSelect:Integer);
    Procedure CopyToClipboard;
    Procedure ClearRowSelect;
  published
    { Published declarations }
    property ColumnCount: integer read GetColumnCount write SetColumnCount;
    Property OneDObjectArray: TArrayofObjects read FOneDObjectArray
      write SetOneDObjectArray;
    Property TwoDObjectArray: TTwoDArrayofObjects read FTwoDObjectArray
      write SetTwoDObjectArray;
    Property FixedCols:Integer Read FFixedCols Write FFixedCols;
  end;

  TAdvStringGrid = TISAdvStringGrid;

procedure Register;

implementation

uses
  Types;


procedure Register;
begin
  RegisterComponents('Innova Solutions', [TISAdvStringGrid]);
end;

{ TISAdvStringGrid }

function TISAdvStringGrid.GetColumnCount: integer;
begin
  Result := inherited ColumnCount;
end;


function TISAdvStringGrid.ObjectSelected: TObject;
Var
  Row,Col:integer;
  ObjMaxRow,ObjMaxCol:Integer;
begin
  Result:=nil;
  ObjMaxCol:=-1;
  ObjMaxRow:=High(FTwoDObjectArray);
  if ObjMaxRow<0 then
     ObjMaxRow:=High(FOneDObjectArray)
    Else
     ObjMaxCol:=High(FTwoDObjectArray[0]);
  if ObjMaxRow<0 then Exit;

  Row:=Selected;
  If Row<0 then exit;
  if Row>ObjMaxRow then exit;

  if ObjMaxCol<0 then
     Result:=FOneDObjectArray[Row]
   else
   begin
     Col:=ColumnIndex;
     if Col<0 then exit;

     if Col>ObjMaxCol then Exit;

     Try
     Result:=FTwoDObjectArray[Row,Col];
     Except
      Result:=nil;
     End;
   end;
end;

procedure TISAdvStringGrid.SelectRows(AFirstRow, ANumberToSelect: Integer);
begin
  //Dummy
end;

procedure TISAdvStringGrid.SetColumnCount(const Value: integer);
Var
  i, CurrentCount: integer;
  NxtColunm: TStringColumn;
begin
  CurrentCount := ColumnCount;
  if Value < CurrentCount then
    For i := CurrentCount - 1 Downto Value - 1 do
      ColumnByIndex(i).Free
  else
    For i := CurrentCount + 1 to Value do
    begin
      NxtColunm := TStringColumn.Create(Self);
      AddObject(NxtColunm);
    end;
end;

procedure TISAdvStringGrid.SetOneDObjectArray(const Value: TArrayofObjects);
begin
  FOneDObjectArray := Value;
  SetLength(FTwoDObjectArray, 0);
end;

procedure TISAdvStringGrid.SetTwoDObjectArray(const Value: TTwoDArrayofObjects);
begin
  FTwoDObjectArray := Value;
  SetLength(FOneDObjectArray, 0);
end;

procedure TISAdvStringGrid.AutoSizeCells(ADoFixed: Boolean; AVPadding,
  AHPadding: Real);
begin
  //Dummy

end;

procedure TISAdvStringGrid.AutoSizeColumns(ADoFixed: Boolean; APadding: Real);
begin
  //Dummy

end;

procedure TISAdvStringGrid.AutoSizeRows(ADoFixed: Boolean; APadding: Real);
begin
  //Dummy

end;

function TISAdvStringGrid.CellMatches(AMatchText: String; ARow, ACol: integer;
  AMatchStates: TFindParams): Boolean;
Var
  CellText, LocalText: String;
  Found, Srch, LookIn: PChar;
begin
  Result := False;

  if fnMatchCase in AMatchStates then
  Begin
    CellText := Trim(Cells[ACol, ARow]);
    LocalText := Trim(AMatchText);
  End
  Else
  Begin
    CellText := Uppercase(Trim(Cells[ACol, ARow]));
    LocalText := Uppercase(Trim(AMatchText));
  End;
  if fnMatchFull in AMatchStates then
  begin
    if Length(Trim(LocalText)) <> Length(Trim(CellText)) then
      Exit
    Else
      Result := LocalText = CellText;
  end
  else
  begin
    LookIn := PChar(CellText);
    Srch := PChar(LocalText);
    Found := StrPos(LookIn, Srch);
    if Found <> nil then
      if fnMatchStart in AMatchStates then
        Result := Found = CellText
      Else
        Result := True;
  end
end;

procedure TISAdvStringGrid.ClearAll;
var
  i: integer;
  Obj: TFmxObject;

begin
  if (Content <> nil) and (Content.ChildrenCount > 0) then
    for i := Content.ChildrenCount - 1 Downto 0 do
      if Content.Children[i] is TColumn then
      begin
        Obj := Content.Children[i];
        Content.RemoveObject(Obj);
        Obj.Free;
      end;
end;

procedure TISAdvStringGrid.ClearRowSelect;
begin
  //Dummy
end;

procedure TISAdvStringGrid.CopyToClipboard;
begin
  //Dummy
end;

function TISAdvStringGrid.Find(AStart: TGridCell; ASearchText: String;
  AMatchStates: TFindParams): TGridCell;
begin
  Result:=FindFirst(ASearchText,AMatchStates);
end;

function TISAdvStringGrid.FindFirst(ASearchText: String;
  AMatchStates: TFindParams): TGridCell;
Var
  DoLeftRight, Done: Boolean;
  Row, Col, MaxCol, MaxRow, OnlyCol, OnlyRow: integer;

begin
  Result.Row := -1;
  Result.Col := -1;
  if ASearchText = '' then
    Exit;

  OnlyCol := -1;
  OnlyRow := -1;
  Row := 0;
  Col := 0;
  if (fnFindInCurrentCol in AMatchStates) then
  Begin
    OnlyCol := ColumnIndex;
    Col := OnlyCol;
  End;
  if (fnFindInCurrentRow in AMatchStates) then
  Begin
    OnlyRow := Selected;
    Row := OnlyRow;
  End;

  DoLeftRight := (fnDirectionLeftRight in AMatchStates);
  MaxCol := ColumnCount - 1;
  MaxRow := RowCount - 1;
  Done := (MaxRow < 0) or (MaxCol < 0);
  while Not Done do
  begin
    If CellMatches(ASearchText, Row, Col, AMatchStates) then
    begin
      Result.Row := Row;
      Result.Col := Col;
      Done := True;
    end
    else if DoLeftRight then
    Begin
      inc(Col);
      if Col > MaxCol then
      begin
        Col := 0;
        inc(Row);
        if OnlyRow > -1 then
          Done := True
        Else
          Done := Row > MaxRow;
      end;
    End
    Else
    begin
      inc(Row);
      if Row > MaxRow then
      begin
        Row := 0;
        inc(Col);
        if OnlyCol > -1 then
          Done := True
        Else
          Done := Col > MaxCol;
      end;
    end;
  end;
  if Not(Result.Row < 0) then
  Begin
    Selected := Result.Row;
    ColumnIndex := Result.Col;
    if (fnAutoGoto in AMatchStates) then;
  End;
end;

end.
