{$I InnovaLibDefs.inc}
unit IsBitButton;
// Reference
// http://docwiki.embarcadero.com/RADStudio/en/Creating_a_FireMonkey_Component

interface

uses
  System.SysUtils, System.Classes,
{$IFDEF ISXE4_DELPHI}
  FMX.Graphics,
  FMX.StdCtrls,
  FMX.Styles,
{$EndIf}
  FMX.Types, FMX.Controls, FMX.Objects;

type
  TIsBitButton = class(TButton)
  private
    { Private declarations }
    FBitmap:TBitmap;
    procedure SetBitmap(Value:TBitmap);
    procedure BitMapChanged(Sender: TObject);
  protected
    { Protected declarations }
    procedure ApplyStyle;override;

{$IFDEF ISXE3_DELPHI}
    function GetStyleObject: TFmxObject; override;
{$Else}
    function GetStyleObject: TControl; override;
{$EndIf}
  public
    { Public declarations }
    Constructor Create(AOwner: TComponent);override;
  published
    { Published declarations }
    property BitMap:TBitmap read FBitmap write SetBitmap;
  end;

procedure Register;

implementation
 uses Types;
{$IFDEF MACOS}
{$R *.mac.res}
{$ENDIF}
{$IFDEF MSWINDOWS}
{$R *.win.res}
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Innova Solutions', [TIsBitButton]);
end;

{ TIsBitButton }

procedure TIsBitButton.ApplyStyle;
var
  T: TFmxObject;
begin
  inherited;
  T := FindStyleResource('isbitbuttonimage');
  if (T <> nil) and (T is TImage) then
  begin
    if FBitmap<>nil then
        TImage(T).Bitmap.Assign(FBitmap)
     else
        Bitmap:=  TImage(T).Bitmap;
    repaint;
  end;
end;



procedure TIsBitButton.BitMapChanged(Sender: TObject);
begin
 ApplyStyle;
 FRecalcUpdateRect:=true;
 Repaint;
end;

constructor TIsBitButton.Create(AOwner: TComponent);
var
  T: TFmxObject;
begin
  inherited;
  FBitmap:=TBitmap.Create(10,10);
  FBitmap.Canvas.DrawLine(PointF(2.0,2.0),Pointf(8.0,8.0),5);
  FBitmap.Canvas.DrawLine(PointF(8.0,2.0),Pointf(2.0,8.0),5);
  FBitmap.Canvas.DrawLine(PointF(2.0,8.0),Pointf(8.0,8.0),5);
  FBitmap.Canvas.DrawLine(PointF(2.0,2.0),Pointf(8.0,2.0),5);
  FBitmap.Canvas.DrawLine(PointF(8.0,2.0),Pointf(8.0,8.0),5);
  FBitmap.Canvas.DrawLine(PointF(2.0,2.0),Pointf(2.0,8.0),5);
  FBitmap.OnChange:=BitMapChanged;
end;

{$IFDEF ISXE3_DELPHI}
function TIsBitButton.GetStyleObject: TFmxObject;
const
  Style = 'ISBitButtonStyle';
var
  S: TResourceStream;
begin
  if (StyleLookup = '') then
  begin
    Result := TControl(TStyleManager.LoadFromResource(HInstance, Style,
      RT_RCDATA));
    Exit;
  end;
  Result := inherited GetStyleObject;
end;

{$Else}
function TIsBitButton.GetStyleObject: TControl;
var
  S: TResourceStream;
const
  Style = 'ISBitButtonStyle';
begin
  if (FStyleLookup = '') then
  begin
    if FindRCData(HInstance, Style) then
    begin
      S := TResourceStream.Create(HInstance, Style, RT_RCDATA);
      try
        Result :=  TControl(CreateObjectFromStream(nil, S));
        Exit;
      finally
        S.Free;
      end;
    end;
  end;
  Result := inherited GetStyleObject;
end;
{$EndIf}

procedure TIsBitButton.SetBitmap(Value: TBitmap);
begin
 if FBitmap <> nil then
   FBitmap.Assign(Value);
 ApplyStyle;
 FRecalcUpdateRect:=true;
 Repaint;
end;

end.
